﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO.Ports;
using System.Threading;
using System.Windows.Forms;

namespace DMX_Revolution
{
    public class Port
    {
        // Hier wird ein SerialPort angelegt und standardmäßig auf COM1 gelegt, da dieser immer vorhanden ist.
        SerialPort port = new SerialPort("COM1", 38400, 0, 8, StopBits.One);

        public Port(string portname)
        {
            //Der Portname wird an dieser Stelle neun konfiguriert, falls er nicht COM1 sein sollte.
            port.PortName = portname;
        }

        public void start()
        {
            // SerialPort wird gestartet
            port.Open();
        }

        public void stop()
        {
            //SerialPort wird gestoppt
            port.Close();
        }

        public void send(int channel, int value)
        {
            //Dies ist die Sendevorrichtung. Hier wird das Eingangssignal empfangen, und nach kurzer bearbeitung in einen gültigen Befehl umgewandelt, der dann an den SerialPort gesendet wird.

            channel--;
            value--;

            string chan, val;
            chan = channel.ToString();
            val = value.ToString();

            //Trimm auf die richtige Länge

            if (val.Length == 1)
                val = "00" + val;
            if (val.Length == 2)
                val = "0" + val;

            //Trimm auf die richtige Länge

            if (chan.Length == 1)
                chan = "00" + chan;
            if (chan.Length == 2)
                chan = "0" + chan;

            //Kommando wird zusammengesetzt

            string command = "C" + chan + "L" + val;

            //Kommand wird gesendet

            port.Write(command);
        }

        public string get(string str)
        {
            //Hier können Satusabfragen über das DMX Interface gemacht werden, z.B. kann der Wert eines Kanals abgefragt werden, ohne ihn festzulegen. Dies ist zwar hiermit implementiert, wird jedoch nciht genutzt.

            port.Write(str);
            Thread.Sleep(50);
            int z = port.BytesToRead;
            Thread.Sleep(50);
            return port.ReadLine() ;
        }

    }
}
